library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.SHA256_PACKAGE.all;

entity S0_BLOCK is
	port( X : in std_logic_vector(31 downto 0);
		  O : out std_logic_vector(31 downto 0));
end S0_BLOCK;

architecture BEHAVIORAL of S0_BLOCK is

	signal ROR7 : std_logic_vector(31 downto 0);
	signal ROR18 : std_logic_vector(31 downto 0);
	signal SHR3 : std_logic_vector(31 downto 0);

begin

	ROR7 <= X(6 downto 0) & X(31 downto 7);
	ROR18 <= X(17 downto 0) & X(31 downto 18);
	SHR3 <= "000" & X(31 downto 3);

	O <= ROR7 xor ROR18 xor SHR3;

end BEHAVIORAL;